﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Config
{
    public partial class UCTabAvatar : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        public UCTabAvatar()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCOptionsDetails UCDetails
        {
            get { return (UCOptionsDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            _gftpControlLoad.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlLoad.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlLoad.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(ImageChangedLoad);
            _gPictureBoxLoad.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);

            _gftpControlCheck.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlCheck.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlCheck.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(ImageChangedCheck);
            _gPictureBoxCheck.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);

            _gftpControlResolve.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlResolve.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlResolve.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(ImageChangedResolve);
            _gPictureBoxResolve.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
        }

        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            Gemini.Core.WinForms.Controls.GPictureBox _gPictureBox = sender as Gemini.Core.WinForms.Controls.GPictureBox;

            if (_gPictureBox != null)
            {
                _gPictureBox.Visible = true;
            }

        }

        void ImageChangedLoad()
        {
            if (_gftpControlLoad.IsFileExist)
            {
                _gPictureBoxLoad.Visible = false;
                _gPictureBoxLoad.LoadAsync(_gftpControlLoad.URL);
            }
            else
            {
                _gPictureBoxLoad.Visible = false;
            }
        }

        void ImageChangedCheck()
        {
            if (_gftpControlCheck.IsFileExist)
            {
                _gPictureBoxCheck.Visible = false;
                _gPictureBoxCheck.LoadAsync(_gftpControlCheck.URL);
            }
            else
            {
                _gPictureBoxCheck.Visible = false;
            }
        }

        void ImageChangedResolve()
        {
            if (_gftpControlResolve.IsFileExist)
            {
                _gPictureBoxResolve.Visible = false;
                _gPictureBoxResolve.LoadAsync(_gftpControlResolve.URL);
            }
            else
            {
                _gPictureBoxResolve.Visible = false;
            }
        }

        public override bool DoSave()
        {
            bool _return = true;

            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Width, BL.Dictionary.Clients.PlugIn, _gTextBoxWidth.Integer);

            #region Load
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Load.Text, BL.Dictionary.Clients.PlugIn, _gMemoEditLoad.Text);

            if (_gftpControlLoad.IsFileExist)
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Load.ImageID, BL.Dictionary.Clients.PlugIn, _gftpControlLoad.ID);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Load.ImageURL, BL.Dictionary.Clients.PlugIn, _gftpControlLoad.URL);
            }
            else
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Load.ImageID, BL.Dictionary.Clients.PlugIn, (long?)null);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Load.ImageURL, BL.Dictionary.Clients.PlugIn, String.Empty);
            }
            #endregion

            #region Check
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Check.Text, BL.Dictionary.Clients.PlugIn, _gMemoEditCheck.Text);

            if (_gftpControlCheck.IsFileExist)
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Check.ImageID, BL.Dictionary.Clients.PlugIn, _gftpControlCheck.ID);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Check.ImageURL, BL.Dictionary.Clients.PlugIn, _gftpControlCheck.URL);
            }
            else
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Check.ImageID, BL.Dictionary.Clients.PlugIn, (long?)null);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Check.ImageURL, BL.Dictionary.Clients.PlugIn, String.Empty);
            }
            #endregion

            #region Resolve
            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Resolve.Text, BL.Dictionary.Clients.PlugIn, _gMemoEditResolve.Text);

            if (_gftpControlResolve.IsFileExist)
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Resolve.ImageID, BL.Dictionary.Clients.PlugIn, _gftpControlResolve.ID);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Resolve.ImageURL, BL.Dictionary.Clients.PlugIn, _gftpControlResolve.URL);
            }
            else
            {
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Resolve.ImageID, BL.Dictionary.Clients.PlugIn, (long?)null);
                _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.Avatar.Resolve.ImageURL, BL.Dictionary.Clients.PlugIn, String.Empty);
            }
            #endregion

            return _return;
        }

        public override void DoRestore()
        {
            _gTextBoxWidth.Integer = UCDetails.BLVariableRepository.GetInt(BL.Dictionary.Config.Avatar.Width, BL.Dictionary.Clients.PlugIn);

            #region Load
            _gMemoEditLoad.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Avatar.Load.Text, BL.Dictionary.Clients.PlugIn);
            _gftpControlLoad.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.Avatar.Load.ImageID, BL.Dictionary.Clients.PlugIn);
            _gPictureBoxLoad.Visible = false;
            if (_gftpControlLoad.ID.HasValue)
            {
                string _imageURLLoad = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Avatar.Load.ImageURL, BL.Dictionary.Clients.PlugIn);
                if (!String.IsNullOrEmpty(_imageURLLoad))
                {
                    _gPictureBoxLoad.Visible = false;
                    _gPictureBoxLoad.LoadAsync(_imageURLLoad);
                }
            }
            #endregion

            #region Check
            _gMemoEditCheck.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Avatar.Check.Text, BL.Dictionary.Clients.PlugIn);
            _gftpControlCheck.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.Avatar.Check.ImageID, BL.Dictionary.Clients.PlugIn);
            _gPictureBoxCheck.Visible = false;
            if (_gftpControlCheck.ID.HasValue)
            {
                string _imageURLCheck = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Avatar.Check.ImageURL, BL.Dictionary.Clients.PlugIn);
                if (!String.IsNullOrEmpty(_imageURLCheck))
                {
                    _gPictureBoxCheck.Visible = false;
                    _gPictureBoxCheck.LoadAsync(_imageURLCheck);
                }
            }
            #endregion

            #region Resolve
            _gMemoEditResolve.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Avatar.Resolve.Text, BL.Dictionary.Clients.PlugIn);
            _gftpControlResolve.ID = UCDetails.BLVariableRepository.GetLong(BL.Dictionary.Config.Avatar.Resolve.ImageID, BL.Dictionary.Clients.PlugIn);
            _gPictureBoxResolve.Visible = false;
            if (_gftpControlResolve.ID.HasValue)
            {
                string _imageURLResolve = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.Avatar.Resolve.ImageURL, BL.Dictionary.Clients.PlugIn);
                if (!String.IsNullOrEmpty(_imageURLResolve))
                {
                    _gPictureBoxResolve.Visible = false;
                    _gPictureBoxResolve.LoadAsync(_imageURLResolve);
                }
            }
            #endregion
        }
    }
}
